addpath util
addpath data
addpath NN

clear;
f1 = fopen('X_train.txt');
frewind(f1);   
tline = fgetl(f1);  

tr_x = zeros(1,562);
while ischar(tline) 
    t1 = strsplit(tline, ' ');
    temp = zeros(1,562);
    for i=1:562
        info = t1(1,i);
        temp(1,i) = str2double(info{1});
    end
    tr_x = [tr_x; temp];

    tline = fgetl(f1);  
end
 
fclose(f1);


f2 = fopen('X_test.txt');
frewind(f2);   
tline = fgetl(f2);  

te_x = zeros(1,562);
while ischar(tline) 
    t1 = strsplit(tline, ' ');
    temp = zeros(1,562);
    for i=1:562
        info = t1(1,i);
        temp(1,i) = str2double(info{1});
    end
    te_x = [te_x; temp];

    tline = fgetl(f2); 
end
 
fclose(f2);

tr_x(1,:) = [];
te_x(1,:) = [];

tr_x(isnan(tr_x)) = 0;
te_x(isnan(te_x)) = 0;


data1 = dlmread('y_train.txt',' ');
data2 = dlmread('y_test.txt',' ');

[d11,d12] = size(data1);
[d21,d22] = size(data2);

tr_y = zeros(d11,6);
te_y = zeros(d21,6);

for i=1:d11
    tr_y(i,data1(i,1)) = 1;
end

for i=1:d21
    te_y(i,data2(i,1)) = 1;
end

%train_x = double(train_x) / 255;
train_x = tr_x;
test_x = te_x;

%train_y = double(train_y);
train_y = tr_y;
test_y  = te_y;

% normalize
[train_x, mu, sigma] = zscore(train_x);
test_x = normalize(test_x, mu, sigma);
%% ex1 vanilla neural net

rand('state',0)
nn = nnsetup([562 500 500 6]);
opts.numepochs =  1;   %  Number of full sweeps through data
opts.batchsize = 1;  %  Take a mea  n gradient step over this many samples

tic;
[nn, L] = nntrain(nn, train_x, train_y, opts);
[er, bad] = nntest(nn, test_x, test_y);
tc = toc;

disp(er);
disp(tc);
disp('here');
assert(er < 0.08, 'Too big error');
